<?php 

namespace App\Models;
use CodeIgniter\Model;

class RadioModel extends Model{
    
    protected $table = 'tbl_radio';
    protected $primaryKey = 'id';
    protected $allowedFields = [];
    
    public function __construct(){
        parent::__construct();
        $this->allowedFields = $this->db->getFieldNames($this->table);
    }
    
    public function getRecentlyRadio($ids, $home_limit){
        if (empty($ids)) {
            return [];
        }
        $builder = $this->db->table('tbl_radio');
        $builder->select('tbl_radio.*, tbl_category.category_name');
        $builder->join('tbl_category', 'tbl_radio.cat_id = tbl_category.cid', 'left');
        $builder->whereIn('tbl_radio.id', $ids);
        $builder->where('tbl_radio.status', 1);
        $builder->where('tbl_category.status', 1);
        $builder->orderBy('tbl_radio.id', 'DESC');
        $builder->limit($home_limit);
        return $builder->get()->getResultArray();
    }

    public function getLatestRadio($home_limit){
        $builder = $this->db->table('tbl_radio');
        $builder->select('tbl_radio.*, tbl_category.category_name');
        $builder->join('tbl_category', 'tbl_radio.cat_id = tbl_category.cid', 'left');
        $builder->where('tbl_radio.status', 1);
        $builder->where('tbl_category.status', 1);
        $builder->orderBy('tbl_radio.id', 'DESC');
        $builder->limit($home_limit);
        return $builder->get()->getResultArray();
    }
    
    public function getTrendingRadios($limit){
        $builder = $this->db->table('tbl_radio_views');
        $builder->select('tbl_radio.*, tbl_category.category_name, COUNT(tbl_radio_views.radio_id) AS views');
        $builder->join('tbl_radio', 'tbl_radio_views.radio_id = tbl_radio.id', 'left');
        $builder->join('tbl_category', 'tbl_radio.cat_id = tbl_category.cid', 'left');
        $builder->where('tbl_radio.status', 1);
        $builder->where('tbl_category.status', 1);
        $builder->where("tbl_radio_views.date BETWEEN DATE_SUB(NOW(), INTERVAL 30 DAY) AND NOW()");
        $builder->groupBy('tbl_radio.id');
        $builder->orderBy('views', 'DESC');
        $builder->limit($limit);
        return $builder->get()->getResultArray();
    }
}